﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace DMX_Revolution
{
    public partial class ColorControl : Form
    {
        public ColorControl()
        {
            InitializeComponent();
            numericUpDown1.Value = 10;
            numericUpDown2.Value = 50;
            comboBox1.SelectedText = "BW";
        }

        public Color col()
        {
            int alpha, red, green, blue;
            alpha = trackBar5.Value;
            red = trackBar1.Value;
            green = trackBar2.Value;
            blue = trackBar3.Value;

            return Color.FromArgb(alpha, red, green, blue);
        }

        //Eigener EventHandler um eine Farbe(Color) zu übergeben, wird hier Instanziert.

        public event EventHandler<Control> Control;

        private void button1_Click(object sender, EventArgs e)
        {
            //Eine art Blackout, der die relevanten Farbwerte auf 1 (Null) zurücksetzt.
            //Hier wird anschließend auch der Regler gesetzt.

            trackBar1.Value = 1;
            val_red.Text = "1";
            trackBar2.Value = 1;
            val_green.Text = "1";
            trackBar3.Value = 1;
            val_blue.Text = "1";
            trackBar4.Value = 1;
            val_amber.Text = "1";
            trackBar5.Value = 1;
            val_alpha.Text = "1";

            //Farbwert wird übergeben

            Control(this, new Control(1, trackBar1.Value));
            Control(this, new Control(2, trackBar2.Value));
            Control(this, new Control(3, trackBar3.Value));
            Control(this, new Control(4, trackBar4.Value));
            Control(this, new Control(5, trackBar5.Value));
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //Eine art Full, der die relevanten Farbwerte auf 1 (Null) zurücksetzt.
            //Hier wird anschließend auch der Regler gesetzt.

            trackBar1.Value = 255;
            val_red.Text = "255";
            trackBar2.Value = 255;
            val_green.Text = "255";
            trackBar3.Value = 255;
            val_blue.Text = "255";
            trackBar4.Value = 255;
            val_amber.Text = "255";
            trackBar5.Value = 255;
            val_alpha.Text = "255";

            //Farbwert wird übergeben

            Control(this, new Control(1, trackBar1.Value));
            Control(this, new Control(2, trackBar2.Value));
            Control(this, new Control(3, trackBar3.Value));
            Control(this, new Control(4, trackBar4.Value));
            Control(this, new Control(5, trackBar5.Value));
        }


        //Im folgenden die Events für die Regeler für die manuelle Farbsteuerung bestimmt.
        //Jedes Event schickt dann den neuen Farbwert an den SerialPort an die Sendefunktion.

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            val_red.Text = trackBar1.Value.ToString();
            pictureBox1.BackColor = col();
            Control(this, new Control(1, trackBar1.Value));
        }

        private void trackBar2_ValueChanged(object sender, EventArgs e)
        {
            val_green.Text = trackBar2.Value.ToString();
            pictureBox1.BackColor = col();
            Control(this, new Control(2, trackBar2.Value));
        }

        private void trackBar3_ValueChanged(object sender, EventArgs e)
        {
            val_blue.Text = trackBar3.Value.ToString();
            pictureBox1.BackColor = col();
            Control(this, new Control(3, trackBar3.Value));
        }

        private void trackBar4_ValueChanged(object sender, EventArgs e)
        {
            val_amber.Text = trackBar4.Value.ToString();
            pictureBox1.BackColor = col();
            Control(this, new Control(4, trackBar4.Value));
        }

        private void trackBar5_ValueChanged(object sender, EventArgs e)
        {
            val_alpha.Text = trackBar5.Value.ToString();
            pictureBox1.BackColor = col();
            Control(this, new Control(5, trackBar5.Value));
        }

        //Hier wedren die Events für die Stroboskop Funktion instanziert.

        public event EventHandler<Strobo> BwStrobo;
        public event EventHandler<Strobo> ColorStrobo;


        //Hier werden die Argumente die im Stroboskop-Formular eingegeben werden, an die jeweilige Funktion geschickt.

        private void button3_Click(object sender, EventArgs e)
        {
            if (comboBox1.SelectedItem != null)
            {
                switch (comboBox1.SelectedItem.ToString())
            {
                case "BW":
                    BwStrobo(this, new Strobo((int)numericUpDown1.Value, (int)numericUpDown2.Value));
                    break;
                case "Color":
                    ColorStrobo(this, new Strobo((int)numericUpDown1.Value, (int)numericUpDown2.Value));
                    break;
                default:
                    BwStrobo(this, new Strobo((int)numericUpDown1.Value, (int)numericUpDown2.Value));
                    break;
            }
            }
        }

    }

    //Hier werden im folgenden einige eigene EventHandler deklariert die in der Lade sind, spezifische Argumente zu übergeben (Color, Strobo-Args, etc.)

    public class ColorEvent : EventArgs
    {
        Color color;

        public ColorEvent(Color col)
        {
            color = col;
        }

        public Color Color
        {
            get { return color; }
            set { color = value; }
        }
     }
    public class Control : EventArgs
    {
        public Control(int c, int v)
        {
            channel = c;
            value = v;
        }

        int channel;

        public int Channel
        {
            get { return channel; }
            set { channel = value; }
        }
        int value;

        public int Value
        {
            get { return this.value; }
            set { this.value = value; }
        }
    }
    public class Strobo : EventArgs
    {
        public Strobo(int m, int t)
        {
            ms = m;
            times = t;
        }
        int ms, times;

        public int Ms
        {
            get { return ms; }
            set { ms = value; }
        }

        public int Times
        {
            get { return times; }
            set { times = value; }
        }
    }
}
